CREATE TABLE [dbo].[TYPE_OF_MOVEMENT]
(
[IEN] [int] NOT NULL IDENTITY(1, 1),
[NAME] [nvarchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL
) ON [PRIMARY]
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO

CREATE TRIGGER [dbo].[TYPE_OF_MOVEMENT_tgg_delete]
   ON  [dbo].[TYPE_OF_MOVEMENT]
   AFTER DELETE
AS 
BEGIN	
	INSERT INTO [dbo].[TYPE_OF_MOVEMENT_LOG]
           ([ACTION],[IEN],[NAME])
        SELECT 'D',[IEN],[NAME]
        FROM deleted;
END

GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO

CREATE TRIGGER [dbo].[TYPE_OF_MOVEMENT_tgg_insert]
   ON  [dbo].[TYPE_OF_MOVEMENT]
   AFTER insert
AS 
BEGIN	
	INSERT INTO [dbo].[TYPE_OF_MOVEMENT_LOG]
           ([ACTION],[IEN],[NAME])
        SELECT 'I',[IEN],[NAME]
        FROM inserted;
END

GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO

CREATE TRIGGER [dbo].[TYPE_OF_MOVEMENT_tgg_update]
   ON  [dbo].[TYPE_OF_MOVEMENT]
   AFTER UPDATE
AS 
BEGIN	
	INSERT INTO [dbo].[TYPE_OF_MOVEMENT_LOG]
           ([ACTION],[IEN],[NAME])
        SELECT 'U',[IEN],[NAME]
        FROM inserted;
END

GO
ALTER TABLE [dbo].[TYPE_OF_MOVEMENT] ADD CONSTRAINT [PK_TYPE_OF_MOVEMENT] PRIMARY KEY CLUSTERED  ([IEN]) ON [PRIMARY]
GO
EXEC sp_addextendedproperty N'MS_Description', N'Contains list of types of movement.', 'SCHEMA', N'dbo', 'TABLE', N'TYPE_OF_MOVEMENT', NULL, NULL
GO
